<?php
  $page_title = 'All Plans';
  require_once('includes/load.php');
  // Checkin What level user has permission to view this page
  page_require_level(1);
  
  $all_plans = find_all('plandetails')

?>
<?php
 if(isset($_POST['add_pla'])){
   $req_field = array('plan-name');
   validate_fields($req_field);
   $pla_number = remove_junk($db->escape($_POST['plan-number']));
   $pla_name = remove_junk($db->escape($_POST['plan-name']));
   $pla_startDate = remove_junk($db->escape($_POST['start-date']));
   $pla_endDate = remove_junk($db->escape($_POST['end-date']));
   $userid = current_user();
     $p_userid = $userid['id'];
   if(empty($errors)){
      $sql  = "INSERT INTO plandetails (planNumber,PlanName,id,StartDate,EndDate)";
      $sql .= " VALUES ('{$pla_number}','{$pla_name}','{$p_userid}','{$pla_startDate}','{$pla_endDate}')";
      if($db->query($sql)){
        $session->msg("s", "Successfully Added New Plan");
        redirect('plan.php',false);
      } else {
        $session->msg("d", "Sorry Failed to insert.");
        redirect('plan.php',false);
      }
   } else {
     $session->msg("d", $errors);
     redirect('plan.php',false);
   }
 }

 if(isset($_GET['complete'])) {

  $planid=$_GET['PlanId'];

  if(!empty($planid)){
    $sql  = "UPDATE plandetails SET Status=1";
    $sql .= " WHERE PlanId=".$planid;
    if($db->query($sql)){

      $delete_draftplan = delete_all('draftplandetails',(int)$planid,'PlanId');

      $delete_planmapped = delete_all('planarticlemapping',(int)$planid,'PlanId');

      $session->msg("s", "Plan Status Successfully Marked as Completed");
      redirect('plan.php',false);
    } else {
      $session->msg("d", "Sorry Failed to Change the Plan Status.");
      redirect('plan.php',false);
    }
 } else {
   $session->msg("d", $errors);
   redirect('plan.php',false);
 }

}

if(isset($_GET['excel'])) {
  
  $planid=$_GET['PlanId'];

  $results=join_salesplan_table_plan_export($planid);

  $tasks = array();
  while( $rows = mysqli_fetch_assoc($results) ) {
  $tasks[] = $rows;
  }

  $filename = "MM_Reqirement_Plan_export_".date('Ymd') . ".xls";
      header("Content-Type: application/vnd.ms-excel");
  header("Content-Disposition: attachment; filename=\"$filename\"");
  ExportFile($tasks);
  //print_r($tasks);
  //echo "yes";die();

}

?>
<?php include_once('layouts/header.php'); ?>

  <div class="row">
     <div class="col-md-12">
       <?php echo display_msg($msg); ?>
     </div>
  </div>
   <div class="row">
    <div class="col-md-5">
      <div class="panel panel-default">
        <div class="panel-heading">
          <strong>
            <span class="glyphicon glyphicon-th"></span>
            <span>Add New Plan</span>
         </strong>
        </div>
        <div class="panel-body">
          <form method="post" action="plan.php">
            <div class="form-group">
                <input type="text" class="form-control" name="plan-number" placeholder="Plan Number">
            </div>
            <div class="form-group">
                <input type="text" class="form-control" name="plan-name" placeholder="Plan Name">
            </div>
            <div class="form-group">
            <label for="start-date">Start Date</label>
              <input type="date" class="form-control" name="start-date" id="start-date">
            </div>
            <div class="form-group">
            <label for="start-date">End Date</label>
                <input type="date" class="form-control" name="end-date" placeholder="End Date">
            </div>
            <button type="submit" name="add_pla" class="btn btn-primary">Add Plan</button>
        </form>
        </div>
      </div>
    </div>
    <div class="col-md-7">
    <div class="panel panel-default">
      <div class="panel-heading">
        <strong>
          <span class="glyphicon glyphicon-th"></span>
          <span>All Plans</span>
       </strong>
      </div>
        <div class="panel-body">
          <table id="plantable" class="table table-bordered table-striped table-hover">
            <thead>
                <tr>
                    <th class="text-center" style="width: 50px;">#</th>
                    <th>Plan Number</th>
                    <th>Plan Name</th>
                    <th>Start Date</th>
                    <th>End Date</th>
                    <th class="text-center" style="width: 100px;">Status</th>
                    <th class="text-center" style="width: 100px;">Actions</th>
                </tr>
                
            </thead>
            <tbody>
              <?php foreach ($all_plans as $pla):?>
                <tr>
                    <td class="text-center"><?php echo count_id();?></td>
                    <td><?php echo remove_junk(ucfirst($pla['PlanNumber'])); ?></td>
                    <td><?php echo remove_junk(ucfirst($pla['PlanName'])); ?></td>
                    <td><?php echo remove_junk(ucfirst($pla['StartDate'])); ?></td>
                    <td><?php echo remove_junk(ucfirst($pla['EndDate'])); ?></td>
                    <td><?php if($pla['Status']==1) { echo "Completed"; } else { ?>
                      <a href="plan.php?complete=1&PlanId=<?php echo (int)$pla['PlanId'];?>" class="btn btn-success btn-xs"  title="Complete" data-toggle="tooltip">
                      Mark as completed
                    </a>
                      <?php }; ?></td>
                    <td class="text-center">
                      <div class="btn-group">
                        <a href="edit_plan.php?PlanId=<?php echo (int)$pla['PlanId'];?>"  class="btn btn-xs btn-warning" data-toggle="tooltip" title="Edit">
                          <span class="glyphicon glyphicon-edit"></span>
                        </a>
                        <a href="plan.php?excel=1&PlanId=<?php echo (int)$pla['PlanId'];?>" class="btn btn-info btn-xs"  title="Edit" data-toggle="tooltip">
                      <span class="glyphicon glyphicon-download-alt"></span>
                    </a>
                        <a href="delete_plan.php?PlanId=<?php echo (int)$pla['PlanId'];?>"  class="btn btn-xs btn-danger" data-toggle="tooltip" title="Remove">
                          <span class="glyphicon glyphicon-trash"></span>
                        </a>
                      </div>
                    </td>

                </tr>
              <?php endforeach; ?>
            </tbody>
          </table>
       </div>
    </div>
    </div>
   </div>
  </div>
  <?php include_once('layouts/footer.php'); ?>
