<?php
  $page_title = 'All Article Stages';
  require_once('includes/load.php');
  // Checkin What level user has permission to view this page
  page_require_level(1);
  
  $all_units = find_all('articlestagedetails')
?>
<?php
 if(isset($_POST['add_uni'])){
   $req_field = array('sapcode','clicking','folding','cuttex','printingout','printingin','stitchingout','stitchingin');
   validate_fields($req_field);
   $sapcode = remove_junk($db->escape($_POST['sapcode']));
   $clicking = remove_junk($db->escape($_POST['clicking']));
   $folding = remove_junk($db->escape($_POST['folding']));
   $cuttex = remove_junk($db->escape($_POST['cuttex']));
   $printingout = remove_junk($db->escape($_POST['printingout']));
   $printingin = remove_junk($db->escape($_POST['printingin']));
   $stitchingout = remove_junk($db->escape($_POST['stitchingout']));
   $stitchingin = remove_junk($db->escape($_POST['stitchingin']));
   
   
   $userid = current_user();
     $p_userid = $userid['id'];
   if(empty($errors)){
      $sql  = "INSERT INTO articlestagedetails (SAPCode,Clicking,Folding,Cuttex,PrintingOUT,PrintingIN,StitchingOUT,StitchingIN)";
   $clicking = remove_junk($db->escape($_POST['clicking']));
      $sql .= " VALUES ('{$sapcode}',$clicking,$folding,$cuttex,$printingout,$printingin,$stitchingout,$stitchingin)";
      if($db->query($sql)){
        $session->msg("s", "Successfully Added New Article Stage Details");
        redirect('articlestage.php',false);
      } else {
        $session->msg("d", "Sorry Failed to insert.");
        redirect('articlestage.php',false);
      }
   } else {
     $session->msg("d", $errors);
     redirect('articlestage.php',false);
   }
 }
?>
<?php include_once('layouts/header.php'); ?>

  <div class="row">
     <div class="col-md-12">
       <?php echo display_msg($msg); ?>
     </div>
  </div>
   <div class="row">
    <div class="col-md-12">
      <div class="panel panel-default">
        <div class="panel-heading">
          <strong>
            <span class="glyphicon glyphicon-th"></span>
            <span>Add New Article Stage</span>
         </strong>
        </div>
        <div class="panel-body">
        <div class="col-md-12">
          <form method="post" action="articlestage.php">
          <div class="col-md-6">
            <div class="form-group">
                <input type="text" class="form-control" name="sapcode" placeholder="Article SAP Code" required>
            </div>
            <div class="form-group">
                <input type="number" class="form-control" name="folding" placeholder="Folding" required>
            </div>
            <div class="form-group">
                <input type="number" class="form-control" name="printingout" placeholder="Printing OUT" required>
            </div>
            <div class="form-group">
                <input type="number" class="form-control" name="stitchingout" placeholder="Stitching OUT" required>
            </div>
            </div>
            <div class="col-md-6">
            <div class="form-group">
                <input type="number" class="form-control" name="clicking" placeholder="Clicking" required>
            </div>
            <div class="form-group">
                <input type="number" class="form-control" name="cuttex" placeholder="Cuttex" required>
            </div>
            <div class="form-group">
                <input type="number" class="form-control" name="printingin" placeholder="Printing IN" required>
            </div>
            <div class="form-group">
                <input type="number" class="form-control" name="stitchingin" placeholder="Stitching IN" required>
            </div>
            </div>
            
            <button type="submit" name="add_uni" class="btn btn-primary">Add Stage</button>
        </form>
        </div>
        </div>
      </div>
    </div>
    <div class="col-md-12">
    <div class="panel panel-default">
      <div class="panel-heading">
        <strong>
          <span class="glyphicon glyphicon-th"></span>
          <span>All Article Stages</span>
       </strong>
      </div>
        <div class="panel-body">
          <table id="categorytable" class="table table-bordered table-striped table-hover">
            <thead>
                <tr>
                    <th class="text-center" style="width: 50px;">#</th>
                    <th>SAP Code</th>
                    <th>Clicking</th>
                    <th>Folding</th>
                    <th>Cuttex</th>
                    <th>Printing OUT</th>
                    <th>Printing IN</th>
                    <th>Stitching OUT</th>
                    <th>Stitching IN</th>
                    <th class="text-center" style="width: 100px;">Actions</th>
                </tr>
            </thead>
            <tbody>
              <?php foreach ($all_units as $uni):?>
                <tr>
                    <td class="text-center"><?php echo count_id();?></td>
                    <td><?php echo remove_junk(ucfirst($uni['SAPCode'])); ?></td>
                    <td><?php echo remove_junk(ucfirst($uni['Clicking'])); ?></td>
                    <td><?php echo remove_junk(ucfirst($uni['Folding'])); ?></td>
                    <td><?php echo remove_junk(ucfirst($uni['Cuttex'])); ?></td>
                    <td><?php echo remove_junk(ucfirst($uni['PrintingOUT'])); ?></td>
                    <td><?php echo remove_junk(ucfirst($uni['PrintingIN'])); ?></td>
                    <td><?php echo remove_junk(ucfirst($uni['StitchingOUT'])); ?></td>
                    <td><?php echo remove_junk(ucfirst($uni['StitchingIN'])); ?></td>
                    <td class="text-center">
                      <div class="btn-group">
                        <a href="edit_articlestage.php?StageId=<?php echo (int)$uni['Id'];?>"  class="btn btn-xs btn-warning" data-toggle="tooltip" title="Edit">
                          <span class="glyphicon glyphicon-edit"></span>
                        </a>
                        <a href="delete_articlestage.php?StageId=<?php echo (int)$uni['Id'];?>"  class="btn btn-xs btn-danger" data-toggle="tooltip" title="Remove" onclick="return confirm('Are you sure you want to delete this item?');">
                          <span class="glyphicon glyphicon-trash"></span>
                        </a>
                      </div>
                    </td>

                </tr>
              <?php endforeach; ?>
            </tbody>
          </table>
       </div>
    </div>
    </div>
   </div>
  </div>
  <?php include_once('layouts/footer.php'); ?>
