<?php
$page_title = 'Daily Plan View';
  require_once('includes/load.php');
  // Checkin What level user has permission to view this page
   page_require_level(1);
   $all_plans = join_dailyplan_table();
   $all_planIds =find_all_uniqueall('plandetails','PlanId');

   if(isset($_POST['add_pla'])){
    $req_field = array('planid');
    validate_fields($req_field);
    $daydate ='';
    $pla_number = remove_junk($db->escape($_POST['planid']));
    if(isset($_POST['daydate'])) {
        $daydate = remove_junk($db->escape($_POST['daydate']));
    }

    if($daydate!='') {
        $planwisedetails=join_dailyplan_table_by_feilds(array('PlanId'=>$pla_number,'PlanDate'=>$daydate));
        //print_r($planwisedetails);die();
    } else {
        $planwisedetails=join_dailyplan_table_by_feilds(array('PlanId'=>$pla_number));
        //print_r($planwisedetails);die();
    }
    
    if(!isset($planwisedetails)) {
        $session->msg("d", "Sorry unable to find the plan details.");
        redirect('DailyPlanView.php',false);
    }

   }

   if(isset($_GET['excel'])) {
  
    $planid1=remove_junk($db->escape($_GET['PlanId']));
  
    $results=join_dailyplan_table_by_feilds_export(array('PlanId'=>$planid1));
    
    $tasks = array();
    while( $rows = mysqli_fetch_assoc($results) ) {
    $tasks[] = $rows;
    }
    
    $filename = "Daily_Plan_export_".date('Ymd') . ".xls";
        header("Content-Type: application/vnd.ms-excel");
    header("Content-Disposition: attachment; filename=\"$filename\"");
    ExportFile($tasks);
    //print_r($tasks);
    //echo "yes";die();
  
  }
   
?>
<?php include_once('layouts/header.php'); ?>
<div class="row">
  <div class="col-md-6">
    <?php echo display_msg($msg); ?>
  </div>
</div>
<div class="row">
  <div class="col-md-12">
    <div class="panel panel-default">
    <div class="panel-heading">
          <strong>
            <span class="glyphicon glyphicon-th"></span>
            <span>View Daily Plan</span>
         </strong>
        </div>
      <div class="panel-body">
          <form class="clearfix" method="post" action="DailyPlanView.php">
          <div class="row">
            <div class="col-md-4">
            <div class="form-group">
            <label for="Planid">Plan</label> 
            <select id="PlanId" class="form-control" name="planid" onChange="plandetailsselect()">
                      <option value="">Select Plan</option>
                    <?php  foreach ($all_planIds as $cat): ?>
                      <option value="<?php echo $cat['PlanId']; ?>">
                        <?php echo $cat['PlanName'] ?></option>
                    <?php endforeach; ?>
                    </select>
            </div>
            </div>
            <div class="col-md-4">
            <div class="form-group">
            <label for="start-date">Date</label>
                <input type="date" class="form-control" name="daydate" value="" placeholder="End Date">
            </div>
            </div>
            </div>
            <button type="submit" name="add_pla" class="btn btn-primary">View Plan</button>
        
          </form>
      </div>

    </div>
  </div>

</div>
<?php if(isset($planwisedetails)) { ?>
<div class="row">
  <div class="col-md-12">
    <?php
    if (isset($error_message)) {
      echo display_msg($error_message);
    }
    ?>
  </div>
  <div class="col-md-12">
    
      <div class="panel panel-default">
        <div class="panel-heading clearfix">
         <div class="pull-right">
		   <a href="DailyPlanView.php?excel=1&PlanId=<?php echo $pla_number; ?>" class="btn btn-primary">Export</a>
           <!--<a href="Product_Add.php" class="btn btn-primary">Add New</a>--->
         </div>
        </div>
      
        <table id="dailyplantable" class="table table-bordered table-striped table-hover">
          <thead>
            <tr>
                    <th>#</th>
                    <th>Job No</th>
                    <th>Date</th>
                    <th>Plan Number</th>
                    <th>Plan Name</th>
                    <th>Article</th>
                    <th>Color</th>
                    <th>Size</th>
                    <th>InitialPlan</th>
                    <th>Current Plan</th>
                    <th>4</th>
                    <th>5</th>
                    <th>6</th>
                    <th>7</th>
                    <th>8</th>
                    <th>9</th>
                    <th>10</th>
                    <th>11</th>
                    <th>12</th>
                    <th>Actions</th>
            </tr>
          </thead>
          <tbody>
          <?php foreach ($planwisedetails as $pla):?>
                <tr>
                    <td class="text-center"><?php echo count_id(); ?></td>
                    <td><?php echo remove_junk(ucfirst($pla['JobNo']))?></td>
                    <td><?php echo remove_junk(ucfirst($pla['PlanDate'])); ?></td>
                    <td><?php echo remove_junk(ucfirst($pla['PlanId'])); ?></td>
                    <td><?php echo remove_junk(ucfirst($pla['PlanName'])); ?></td>
                    <td><?php echo remove_junk(ucfirst($pla['ArticleName'])); ?></td>
                    <td><?php echo remove_junk(ucfirst($pla['ColorName'])); ?></td>
                    <td><?php echo remove_junk(ucfirst($pla['SizeAssortment'])); ?></td>
                    <td><?php echo remove_junk(ucfirst($pla['InitialPlan'])); ?></td>
                    <td><?php echo remove_junk(ucfirst($pla['CurrentPlan'])); ?></td>
                    <td><?php echo remove_junk(ucfirst($pla['Four'])); ?></td>
                    <td><?php echo remove_junk(ucfirst($pla['Five'])); ?></td>
                    <td><?php echo remove_junk(ucfirst($pla['Six'])); ?></td>
                    <td><?php echo remove_junk(ucfirst($pla['Seven'])); ?></td>
                    <td><?php echo remove_junk(ucfirst($pla['Eight'])); ?></td>
                    <td><?php echo remove_junk(ucfirst($pla['Nine'])); ?></td>
                    <td><?php echo remove_junk(ucfirst($pla['Ten'])); ?></td>
                    <td><?php echo remove_junk(ucfirst($pla['Eleven'])); ?></td>
                    <td><?php echo remove_junk(ucfirst($pla['Twelve'])); ?></td>
                  
                    <!--<td><?php //if($pla['Status']==1) { echo "Completed"; } else { ?>
                      <a href="plan.php?complete=1&PlanId=<?php //echo (int)$pla['PlanId'];?>" class="btn btn-success btn-xs"  title="Complete" data-toggle="tooltip">
                      Mark as completed
                    </a>-->
                      <?php// }; ?></td>
                    <td class="text-center">
                      <div class="btn-group">
                        <a href="DailyPlanEdit.php?DailyId=<?php echo (int)$pla['Id'];?>"  class="btn btn-xs btn-warning" data-toggle="tooltip" title="Edit">
                          <span class="glyphicon glyphicon-edit"></span>
                        </a>
                        <!--<a href="plan.php?excel=1&PlanId=<?php //echo (int)$pla['PlanId'];?>" class="btn btn-info btn-xs"  title="Edit" data-toggle="tooltip">
                      <span class="glyphicon glyphicon-download-alt"></span>
                    </a>-->
                        <a href="DailyPlanDelete.php?DailyId=<?php echo (int)$pla['Id'];?>"  class="btn btn-xs btn-danger" data-toggle="tooltip" title="Remove" onclick="return confirm('Are you sure you want to delete this item?');">
                          <span class="glyphicon glyphicon-trash"></span>
                        </a>
                      </div>
                    </td>

                </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
  </div>
</div>
<?php } ?>
<?php include_once('layouts/footer.php'); ?>
<?php include_once('layouts/footer.php'); ?>
