<?php
$page_title = 'Draft Plan';
require_once('includes/load.php');
// Checking what level user has permission to view this page
page_require_level(1);



// Fetch data from sapfetcharticles table
$result = get_data_for_articles_rzk();


include_once('layouts/header.php');
?>

<div class="row">
  <div class="col-md-12">
    <?php
    if (isset($error_message)) {
      echo display_msg($error_message);
    }
    ?>
  </div>
  <div class="col-md-12">
    <h4>Item Details</h4>
    <table id="articleplantable" class="table table-bordered table-striped table-hover">
      <thead>
        <tr>
          <th class="text-center">Item Code</th>
          <th class="text-center">Item Name</th>
          <th class="text-center">Quantity</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($result as $row) : ?>
          <tr>
            <td class="text-center"><?php echo $row['itemcode']; ?></td>
            <td class="text-center"><?php echo $row['itemname']; ?></td>
            <td class="text-center">
              <a href="#" onclick="loadUnitQuantity('<?php echo $row['itemcode']; ?>')">
                <?php echo $row['total_quantity']; ?>
              </a>
            </td>
          </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</div>

<div id="unitQuantityTable"></div>


<script>
 function loadUnitQuantity(itemcode) {
    // Perform an AJAX request to fetch unit-wise quantity split-up
    // and populate another table or display the data as desired
    $.ajax({
      url: 'fetch_unit_quantity.php', // Replace with the URL of the script that fetches unit-wise quantity
      method: 'POST',
      data: { itemcode: itemcode },
      success: function(response) {
        $('#unitQuantityTable').html(response);
      },
      error: function(xhr, status, error) {
        // Handle error if any
      }
    });
  }
</script>

<?php include_once('layouts/footer.php'); ?>