<?php
$page_title = 'Draft Plan';
require_once('includes/load.php');
// Checking what level user has permission to view this page
page_require_level(1);

$all_plans = find_all('plandetails'); // Fetch all plans
$all_units = find_all('unitdetails'); // Fetch all units

if(isset($_POST['SPlanId'])){

  $catid  = remove_junk($db->escape($_POST['SPlanId']));
  $subcategorydetails1 = planwise_unit($catid);
  
  header('Content-Type: application/json');
  echo json_encode($subcategorydetails1);
  exit;
  
  }

include_once('layouts/header.php');
?>

<div class="row">
  <div class="col-md-12">
  <?php echo display_msg($msg); ?>
    <form method="POST" action="showdraftplan.php">
    <div class="form-group">
            <select id="PlanId" class="form-control" name="planid" onChange="subcatselectunit()">
                      <option value="">Select Plan</option>
                    <?php  foreach ($all_plans as $cat): ?>
                      <option value="<?php echo $cat['PlanId']; ?>">
                        <?php echo $cat['PlanName'] ?></option>
                    <?php endforeach; ?>
                    </select>
            </div>
            <div class="form-group">
            <select id="UnitId" class="form-control" name="unitid" >
                      <option value="">Select Unit</option>
                    <?php  foreach ($all_units as $unit): ?>
                      <option value="<?php echo $unit['UnitId']; ?>">
                        <?php echo $unit['UnitName'] ?></option>
                    <?php endforeach; ?>
                    </select>
            </div>
            <div class="form-group">
                 <button type="submit" name="submit" class="btn btn-primary">Show Draft Plan</button>
            </div>
    </form>
  </div>
</div>
<script type="text/JavaScript"> 
  function subcatselectunit() {
      var Catvalue=document.getElementById('PlanId').value;
      console.log(Catvalue);

      $.ajax({
    url      : 'showdraftplan_getInput.php',
    data     : {'SPlanId':Catvalue},
    dataType: 'json',
    type     : 'POST',
    success  : function(Result){
              console.log(Result[0]);
              //var myObj = $.parseJSON(Result);
              var myObj =Result;
              $("#UnitId").empty();
              $('#UnitId').append('<option value="">Select Unit </option>');
              //console.log(myObj);
              console.log(Object.keys(myObj).length);
              //you can now access data like this:
              //myObj.Address_1
              $.each(myObj, function (i, value) {
                $('#UnitId').append('<option value=' + value.UnitId + '>' + value.UnitName + '</option>');
            });
        }
    }
  );
    
}
     </script>

<?php include_once('layouts/footer.php'); ?>
