<?php
$page_title = 'Draft Plan';
require_once('includes/load.php');
// Checking what level user has permission to view this page
page_require_level(1);

$selectedPlan = $_POST['planid'];
$selectedUnit = $_POST['unitid'];

if ($selectedPlan && $selectedUnit) {
  echo $selectedPlan; // Move this line inside the if condition

  // Fetch plan name from plandetails table
  $plan = find_by_columnnew('plandetails', $selectedPlan, 'PlanId');
  $planName = isset($plan['PlanName']) ? $plan['PlanName'] : '';

  // Fetch unit name from unitdetails table
  $unit = find_by_columnnew('unitdetails', $selectedUnit, 'UnitId');
  $unitName = isset($unit['UnitName']) ? $unit['UnitName'] : '';

  // Fetch data from draftplandetails table based on the selected plan and unit
  $draftPlanDetails = find_by_fields('draftplandetails', array('planid' => $selectedPlan, 'unitid' => $selectedUnit));

  $bomcreation = bomtablecreationstatuscheck($selectedPlan,$selectedUnit);
    if(!empty($bomcreation)) {

      $error_message =array('danger'=>' Draft plan creation is in progress!');
        //redirect('choosedraftplan.php', false);
    } else {
            //$bomcreation = bomtablecreation($planids,$unitids);
            $error_message =array('success'=>"Draft plan creation completed successfully! ");
            
    }

} else {
  $error_message = 'Please select a plan and unit.';
}

// Handle approve button click
if (isset($_POST['approve'])) {
  $insertadd=0;
  // Update the status column to 1 for the selected plan and unit

  $draftPlanDetailsaprrove = find_by_fields('draftplandetails', array('planid' => $_POST['planid'], 'unitid' => $_POST['unitid']));
  if(!empty($draftPlanDetailsaprrove)) {
      foreach($draftPlanDetailsaprrove as $planitem) {
        //print_r($planitem);die();
        $query  = "INSERT INTO planarticlemapping (";
        $query .=" PlanId,UnitId,SAPCode,Quantity,Status";
        $query .=") VALUES (";
        $query .=" {$planitem['PlanId']}, {$planitem['UnitId']}, '{$planitem['SAPCode']}', {$planitem['ReqStock']}, 0";
        $query .=")";
        $query .=" ON DUPLICATE KEY UPDATE Quantity= {$planitem['ReqStock']},Status=0";

        if($db->query($query)){
          //$session->msg('s',"Product added ");
          //redirect('add_product.php', false);
          $insertadd=1;
        } else {
          //$session->msg('d',' Sorry failed to added!');
          //redirect('product.php', false);
          $insertadd=0;
        }
        //print_r($planitem);die();
      }
  }
  
  //print_r($draftPlanDetailsaprrove);die();

 $approveStatus = update_status_approve_plan($_POST['planid'],  $_POST['unitid'], 1);
 if($approveStatus){
    //sucess
    $session->msg('s',"Successfully approved");
    redirect('showdraftplan_getInput.php', false);
  } else {
    //failed
    $session->msg('d',' Failed to approve');
    redirect('showdraftplan_getInput.php', false);
  }
}


include_once('layouts/header.php');
?>

<div class="row">
  <div class="col-md-12">
    <?php
    if (isset($error_message)) {
      echo display_msg($error_message);
    }
    ?>
  </div>
  <div class="col-md-12">
    <?php if (isset($selectedPlan) && isset($selectedUnit) && isset($draftPlanDetails)) : ?>
      <h4>Selected Plan: <?php echo $planName; ?></h4>
      <h4>Selected Unit: <?php echo $unitName; ?></h4>
      <form method="POST" action="">
        <table id="salesplantable" class="table table-bordered table-striped table-hover">
          <thead>
            <tr>
              <th class="text-center" style="width: 10%;">#</th>
              <th class="text-center" style="width: 10%;">SAP Code</th>
              <th class="text-center" style="width: 10%;">Available Stock</th>
              <th class="text-center" style="width: 10%;">Allocated Stock</th>
              <th class="text-center" style="width: 10%;">Actual Stock Required</th>
              <th class="text-center" style="width: 10%;">Expected Stock Required</th>
              <th class="text-center" style="width: 10%;">Status</th>
            </tr>
          </thead>
          <tbody>
            <?php foreach ($draftPlanDetails as $index => $detail) : ?>
              <tr>
                <td class="text-center"><?php echo $index + 1; ?></td>
                <td class="text-center"><?php echo $detail['SAPCode']; ?></td>
                <td class="text-center"><?php echo $detail['AvlStock']; ?></td>
                <td class="text-center"><?php echo $detail['AlocStock']; ?></td>
                <td class="text-center"><?php echo $detail['ReqStock']; ?></td>
                <td class="text-center"><?php if($detail['AvlStock'] > $detail['ReqStock']) {
                  echo 0;
                }  else {
                  echo $detail['ReqStock']-$detail['AvlStock'];
                }
                ?></td>
                <td class="text-center"><?php if($detail['Status']==0){echo "Draft";} else {echo "Approved";} ?></td>
              </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
        <input type="hidden" name="planid" value="<?php echo $selectedPlan; ?>" />
        <input type="hidden" name="unitid" value="<?php echo $selectedUnit; ?>" />
        <input type="submit" name="approve" class="btn btn-success" value = "Approve"/>
      </form>
    <?php endif; ?>
  </div>
</div>

<?php include_once('layouts/footer.php'); ?>
