<?php
$page_title = 'SAP Data';
require_once 'includes/load.php';
page_require_level(1); // Check user's permission level

// Set default page and number of records per page
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$records_per_page = 50;

// Prepare the WHERE clause for filters
$where = '';
if (isset($_POST['filter'])) {
    $sbu = remove_junk($db->escape($_POST['sbu']));
    $father_name = remove_junk($db->escape($_POST['father_name']));
    $child_name = remove_junk($db->escape($_POST['child_name']));
    $process_order = remove_junk($db->escape($_POST['process_order']));

    $where = " WHERE 1=1 ";
    if (!empty($sbu)) {
        $where .= "AND SBU LIKE '%$sbu%' ";
    }
    if (!empty($father_name)) {
        $where .= "AND `Father Name` LIKE '%$father_name%' ";
    }
    if (!empty($child_name)) {
        $where .= "AND `Child Name` LIKE '%$child_name%' ";
    }
    if (!empty($process_order)) {
        $where .= "AND `Process Order` LIKE '%$process_order%' ";
    }
}

function count_records($table, $where) {
    global $db;
    $sql = "SELECT COUNT(*) FROM $table $where";
    $result = $db->query($sql);
    $row = $result->fetch_row();
    return $row[0];
}

// Calculate the offset and total number of records
$offset = ($page - 1) * $records_per_page;
$total_records = count_records('sourcedatatable', $where);
$total_pages = ceil($total_records / $records_per_page);

function find_with_pagination($table, $offset, $records_per_page, $where) {
    global $db;
    $sql = "SELECT `SBU`, `Father`, `Father Name`, `Father No of pairs`, `Father Qty`, `Child`, `Child Name`, `Child Qty`, `Process`, `Process Order` FROM $table $where";
    $sql .= " LIMIT $offset, $records_per_page";
    return find_by_sql($sql);
}

// Fetch the data from the database
$sap_data = find_with_pagination('sourcedatatable', $offset, $records_per_page, $where);

// Define the column names for the table
$columns = ['SBU', 'Father', 'Father Name', 'Father No of pairs', 'Father Qty', 'Child', 'Child Name', 'Child Qty', 'Process', 'Process Order'];
?>

<?php require_once 'layouts/header.php'; ?>
<div class="row">
    <div class="col-md-12">
        <?= display_msg($msg); ?>
    </div>
</div>
<div class="row">
    <div class="col-md-12">
        <div class="panel panel-default">
            <div class="panel-heading">
                <h3 class="panel-title">SAP Data</h3>
            </div>
            <div class="panel-body">
            <form method="post" action="sapdata.php">
    <div class="form-row">
        <div class="form-group col-md-2">
            <label for="sbu">SBU</label>
            <input type="text" class="form-control" name="sbu" id="sbu" value="<?= isset($sbu) ? $sbu : '' ?>">
        </div>
        <div class="form-group col-md-2">
    <label for="father_name">Father Name</label>
    <input type="text" class="form-control" id="father_name" name="father_name" value="<?= isset($father_name) ? $father_name : ''; ?>">
</div>
        <div class="form-group col-md-2">
            <label for="child_name">Child Name</label>
            <input type="text" class="form-control" name="child_name" id="child_name" value="<?= isset($child_name) ? $child_name : '' ?>">
        </div>
        <div class="form-group col-md-2">
            <label for="process_order">Process Order</label>
            <input type="text" class="form-control" name="process_order" id="process_order" value="<?= isset($process_order) ? $process_order : '' ?>">
        </div>
    </div>
    <div class="form-row">
        <div class="form-group col-md-6">
            <button type="submit" name="filter" class="btn btn-primary"><i class="glyphicon glyphicon-search"></i> Filter</button>
            <a href="sapdata.php" class="btn btn-default"><i class="glyphicon glyphicon-refresh"></i> Reset</a>
        </div>
    </div>
</form>
                <hr>
                <table class="table table-bordered table-striped">
                    <thead>
                        <tr>
                            <?php foreach ($columns as $column) : ?>
                                <th><?= ucwords(str_replace('_', ' ', $column)) ?></th>
                            <?php endforeach; ?>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($sap_data as $data) : ?>
                            <tr>
                                <?php foreach ($columns as $column) : ?>
                                    <td><?= $data[$column] ?></td>
                                <?php endforeach; ?>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
                <?php if ($total_records > 0) : ?>
                  <div class="text-center">
    <ul class="pagination">
        <?php if ($total_pages > 1) : ?>
            <?php $prev_page = $page - 1; ?>
            <?php $next_page = $page + 1; ?>
            <?php $adjacents = 5; ?>
            <?php if ($page > 1) : ?>
                <li><a href="?page=<?= $prev_page ?>">Previous</a></li>
            <?php endif; ?>
            <?php if ($total_pages <= 10 + ($adjacents * 2)) : ?>
                <?php for ($i = 1; $i <= $total_pages; $i++) : ?>
                    <?php if ($i == $page) : ?>
                        <li class="active"><a href="#"><?= $i ?></a></li>
                    <?php else : ?>
                        <li><a href="?page=<?= $i ?>"><?= $i ?></a></li>
                    <?php endif; ?>
                <?php endfor; ?>
            <?php else : ?>
                <?php if ($page <= 6 + $adjacents) : ?>
                    <?php for ($i = 1; $i <= 10 + ($adjacents * 2); $i++) : ?>
                        <?php if ($i == $page) : ?>
                            <li class="active"><a href="#"><?= $i ?></a></li>
                        <?php else : ?>
                            <li><a href="?page=<?= $i ?>"><?= $i ?></a></li>
                        <?php endif; ?>
                    <?php endfor; ?>
                    <li><a href="?page=<?= $total_pages ?>">Last</a></li>
                <?php elseif ($page > $total_pages - 6 - $adjacents) : ?>
                    <li><a href="?page=1">First</a></li>
                    <?php for ($i = $total_pages - 10 - ($adjacents * 2); $i <= $total_pages; $i++) : ?>
                        <?php if ($i == $page) : ?>
                            <li class="active"><a href="#"><?= $i ?></a></li>
                        <?php else : ?>
                            <li><a href="?page=<?= $i ?>"><?= $i ?></a></li>
                        <?php endif; ?>
                    <?php endfor; ?>
                <?php else : ?>
                    <li><a href="?page=1">First</a></li>
                    <?php for ($i = $page - $adjacents; $i <= $page + $adjacents; $i++) : ?>
                        <?php if ($i == $page) : ?>
                            <li class="active"><a href="#"><?= $i ?></a></li>
                        <?php else : ?>
                            <li><a href="?page=<?= $i ?>"><?= $i ?></a></li>
                        <?php endif; ?>
                    <?php endfor; ?>
                    <li><a href="?page=<?= $total_pages ?>">Last</a></li>
                <?php endif; ?>
            <?php endif; ?>
            <?php if ($page < $total_pages) : ?>
                <li><a href="?page=<?= $next_page ?>">Next</a></li>
            <?php endif; ?>
        <?php endif; ?>
    </ul>
</div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<?php require_once 'layouts/footer.php'; ?>
