<?php
  $page_title = 'All RawMaterials';
  require_once('includes/load.php');
  // Checkin What level user has permission to view this page
  page_require_level(1);
  
  $all_rawmaterials = find_all('rawmaterialdetails')
?>
<?php

 if(isset($_POST['add_raw'])){
   $req_field = array('rawmaterial-name');
   validate_fields($req_field);
   $raw_SAP = remove_junk($db->escape($_POST['rawmaterial-SAP']));
   $raw_name = remove_junk($db->escape($_POST['rawmaterial-name']));
   $userid = current_user();
     $p_userid = $userid['id'];
   if(empty($errors)){
      $sql  = "INSERT INTO rawmaterialdetails (RawMaterialSAP,RawMaterialName,id)";
      $sql .= " VALUES ('{$raw_SAP}','{$raw_name}','{$p_userid}')";
      if($db->query($sql)){
        $session->msg("s", "Successfully Added New Raw Material");
        redirect('rawmaterial.php',false);
      } else {
        $session->msg("d", "Sorry Failed to insert.");
        redirect('rawmaterial.php',false);
      }
   } else {
     $session->msg("d", $errors);
     redirect('rawmaterial.php',false);
   }
 }
?>
<?php include_once('layouts/header.php'); ?>

  <div class="row">
     <div class="col-md-12">
       <?php echo display_msg($msg); ?>
     </div>
  </div>
   <div class="row">
    <div class="col-md-5">
      <div class="panel panel-default">
        <div class="panel-heading">
          <strong>
            <span class="glyphicon glyphicon-th"></span>
            <span>Add New Raw Material</span>
         </strong>
        </div>
        <div class="panel-body">
          <form method="post" action="rawmaterial.php">
            <div class="form-group">
                <input type="text" class="form-control" name="rawmaterial-SAP" placeholder="SAP Code">
            </div>
            <div class="form-group">
                <input type="text" class="form-control" name="rawmaterial-name" placeholder="Raw Material Name">
            </div>
           
            <button type="submit" name="add_raw" class="btn btn-primary">Add Raw Material</button>
        </form>
        </div>
      </div>
    </div>
    <div class="col-md-7">
    <div class="panel panel-default">
      <div class="panel-heading">
        <strong>
          <span class="glyphicon glyphicon-th"></span>
          <span>All Raw Materials</span>
       </strong>
      </div>
        <div class="panel-body">
          <table id="rawmaterialtable" class="table table-bordered table-striped table-hover">
            <thead>
                <tr>
                    <th class="text-center" style="width: 50px;">#</th>
                    <th>SAP Code</th>
                    <th>Name</th>
                    <th class="text-center" style="width: 100px;">Actions</th>
                </tr>
                
            </thead>
            <tbody>
              <?php foreach ($all_rawmaterials as $raw):?>
                <tr>
                    <td class="text-center"><?php echo count_id();?></td>
                    <td><?php echo remove_junk(ucfirst($raw['RawMaterialSAP'])); ?></td>
                    <td><?php echo remove_junk(ucfirst($raw['RawMaterialName'])); ?></td>
                    <td class="text-center">
                      <div class="btn-group">
                        <a href="edit_rawmaterial.php?RawMaterialId=<?php echo (int)$raw['RawMaterialId'];?>"  class="btn btn-xs btn-warning" data-toggle="tooltip" title="Edit">
                          <span class="glyphicon glyphicon-edit"></span>
                        </a>
                        <a href="delete_rawmaterial.php?RawMaterialId=<?php echo (int)$raw['RawMaterialId'];?>"  class="btn btn-xs btn-danger" data-toggle="tooltip" title="Remove">
                          <span class="glyphicon glyphicon-trash"></span>
                        </a>
                      </div>
                    </td>

                </tr>
              <?php endforeach; ?>
            </tbody>
          </table>
       </div>
    </div>
    </div>
   </div>
  </div>
  <?php include_once('layouts/footer.php'); ?>
